package com.avaya.ccs.javafxrefclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.avaya.ccs.core.CustomerData;
import com.avaya.ccs.core.CustomerDetails;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class CustomerSearchTab {
	private static final Logger LOG = Logger.getLogger(CustomerSearchTab.class);
	
	private final Tab tab;
	private final InteractionExecutor interactionExe;

	private ObservableList<CustomerDetails> searchResults = FXCollections.observableArrayList();
	private ListView<CustomerDetails> searchResultsListView = new ListView<>();
	
	VBox root;
	VBox allSearchRowsVBox;
	
	ObservableList<String> keys = FXCollections.observableArrayList();
	ObservableList<String> conditions = FXCollections.observableArrayList();
	
	List<Query> allQueries;
	
	private void addSearchRow() {
		
		ComboBox<String> subjectCB= new ComboBox<String>(keys);
		ComboBox<String> operatorsCB= new ComboBox<String>(conditions);
		TextField searchValueTf= new TextField();
		Button addRowButton = new Button("+");
		HBox thisRowHbox= new HBox(5);
		
		addRowButton.setOnAction((ActionEvent t)->{
        	addSearchRow();
        });
		
		thisRowHbox.getChildren().addAll(subjectCB, operatorsCB, searchValueTf, addRowButton);
		allSearchRowsVBox.getChildren().add(thisRowHbox);
		
	}
	
	public CustomerSearchTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
		tab = new Tab();
        tab.setText("Customer Search");
        tab.setClosable(false);
        this.interactionExe=interactionExe;
        Label searchCriteriaLbl= new Label("Search Criteria");
        
        allQueries= new ArrayList<Query>();
        allSearchRowsVBox = new VBox(5);
        
        root= new VBox(5);
        
        keys.addAll(Arrays.asList(
        		"FirstName", 
        		"LastName", 
        		"PreferredAgent",
        		"Address",
        		"EmailAddress",
        		"PhoneNumber",
        		"SIPURI"));
        
        conditions.addAll(Arrays.asList(
        		"Contains", 
        		"Begins With", 
        		"Ends With", 
        		"Is", 
        		"Is Not"));
     
        
        Button btnSearch = new Button("Search");
        Button btnClear = new Button("Clear");
        
        HBox searchButtons= new HBox(5);
        searchButtons.getChildren().addAll(btnSearch, btnClear);
        
        addSearchRow();
        root.getChildren().addAll(searchCriteriaLbl, 
        		allSearchRowsVBox, 
        		searchButtons, 
        		searchResultsListView
        		);

        btnClear.setOnAction((ActionEvent t) -> {
        	allQueries.clear();
        	
        	//remove all rows except the first one
        	for (int i=0; i < allSearchRowsVBox.getChildren().size(); i++) {
        		allSearchRowsVBox.getChildren().remove(i);
        	}
        	addSearchRow();
        	
        	//in row 0, clear all values
        	HBox firstRow = (HBox)allSearchRowsVBox.getChildren().get(0);
        	ComboBox<String> subj = (ComboBox<String>)firstRow.getChildren().get(0);
        	subj.getSelectionModel().clearSelection();
        	ComboBox<String> cond = (ComboBox<String>)firstRow.getChildren().get(1);
        	cond.getSelectionModel().clearSelection();
        	TextField val = (TextField)firstRow.getChildren().get(2);
        	val.setText("");
        	
        	//clear the results
        	searchResults.clear();
        });
        
        btnSearch.setOnAction((ActionEvent t)->{
        	allQueries.clear();
        	searchResults.clear(); 
        	//populate the list of individual queries
        	for (int i=0; i < allSearchRowsVBox.getChildren().size(); i++) {
        		HBox thisQuery = (HBox)allSearchRowsVBox.getChildren().get(i);
        		
        		ComboBox<String> subj = (ComboBox<String>)thisQuery.getChildren().get(0);
        		ComboBox<String> cond = (ComboBox<String>)thisQuery.getChildren().get(1);
        		TextField val = (TextField)thisQuery.getChildren().get(2);
        		
        		Query q = new Query(subj.getValue().toString(),cond.getValue().toString(),val.getText());
        		allQueries.add(q);
        	}
        	
        	
        	StringBuilder queryBuilder = new StringBuilder();
        	queryBuilder.append("{\"SearchCriteriaList\":[");
        	
        	for (int i=0; i< allQueries.size(); i++) {
        		queryBuilder.append("{\"Key\":\"" +allQueries.get(i).key + "\",\"Condition\":\""+ allQueries.get(i).condition + "\",\"Value\":\"" +allQueries.get(i).value  
        	+"\"}");
        		//comma-seperate all entries exceopt the last
        		if (i<(allQueries.size()-1))
        			queryBuilder.append(",");
        	}
        	queryBuilder.append("]}");
        	
        	LOG.info("CustomerSearchTab. Query: " + queryBuilder.toString());
        	this.interactionExe.searchCustomers(queryBuilder.toString());
        	
        });
        
        searchResultsListView.setItems(searchResults); 
        tab.setContent(root);
        tab.setDisable(false);
	}

	public Tab getTab() {
		return tab;
	}
	
	public void setSearchResults(CustomerData c){
		List<CustomerDetails> items = Arrays.asList(c.getCustomerList().getCustomerList());
		items.stream().forEach( i -> searchResults.add(i));		
	}
}

class Query{
	String key;
	String condition;
	String value;
	
	public Query(String key, String condition, String value) {
		this.key=key;
		this.condition=condition;
		this.value=value;
	}
}
